<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Book;
use App\Models\Contact;
use App\Models\Event;
use App\Models\Files;
use App\Models\Gallery;
use App\Models\Partner;
use App\Models\Publisher; 
use App\Models\Team;
use App\Models\User;
use App\Models\Writer;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Mail\WelcomeMail;
use Illuminate\Support\Facades\Mail;

class PageController extends Controller
{
    public function __construct() {
        \View::share('is_page', 'home');
    }
    public function about(Request $request)
    {
        $og_title = "معرض الكتاب الإسلامي | ";
        $og_sub_title = "";
        $og_image = "";
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);

        $title = __('front.about-page name');
        $subtitle = __('front.about-page subtitle');
        $banner = getImage(getSettingValue('about'));
        $content = getSettingValue('about_'.app()->getLocale());
        \View::share('is_page', 'about');
        $about_slider = Gallery::whereNull('type')->orderby('sort_by', 'asc')->get();
        $partners = Partner::orderby('sort_by', 'asc')->limit(6)->get();
        $teams = Team::orderby('sort_by', 'asc')->limit(4)->get();
        return view('front.pages.about', compact('title', 'teams', 'content', 'banner', 'subtitle', 'about_slider', 'partners') );
    }
    public function publishers(Request $request)
    {

        $og_title = "معرض الكتاب الإسلامي | دور النشر";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.services-page name');
        $subtitle = '';
        $banner = getImage(getSettingValue('publishers'));
        $publishers = Publisher::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $publishers->where('name', 'LIKE', "%$request->s%");
        }
        if ($request->has('b') && !empty($request->b)) {
            $publishers->where('place_1', 'LIKE', "$request->b");
        }
        $publishers = $publishers->paginate(15);
        \View::share('is_page', 'publishers');
        return view('front.pages.publishers', compact('title', 'publishers', 'banner', 'subtitle') );
    } 
    
    public function publishersAjx(Request $request)
    {
        $publishers = Publisher::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $publishers->where('title', 'LIKE', "%$request->s%");
        }
        if ($request->has('b') && !empty($request->b) && $request->b != 'undefined') {
            $publishers->where('place_1', 'LIKE', "$request->b");
        }
        $publishers = $publishers->paginate(15);
        $p = $publishers->currentPage() + 1;
        $nxt = true;
        if ($p > $publishers->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.publishers_table', compact('publishers') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }                  
    public function guide(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | دليل المعرض ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.guide-page name');
        $subtitle = '';
        $banner = getImage(getSettingValue('guide'));
        \View::share('is_page', 'guide');
        $rows = Book::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $rows->where('title', 'LIKE', "%$request->s%");
        }
        $rows = $rows->paginate(15);
        return view('front.pages.guide', compact('title', 'rows', 'banner', 'subtitle') );
    }
    public function guideAjx(Request $request)
    {
        $rows = Book::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $rows->where('title', 'LIKE', "%$request->s%");
        }
        $rows = $rows->paginate(15);
        $p = $rows->currentPage() + 1;
        $nxt = true;
        if ($p > $rows->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.guide_table', compact('rows') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }
    public function compitation(Request $request)
    {

        $og_title = "معرض الكتاب الإسلامي | المسابقة";
        $og_sub_title = "";
        $string = url()->current();

        if (substr($string, -1) === '/') {
            $string = rtrim($string, '/');
        } else {
            $string = $string . '/';
        }
        if ($row = \App\Models\Seo::whereIn('url', [url()->current(), $string])->first() ) {
            $og_title = $row->title;
            // $s_keywords = $row->keywords;
            $og_sub_title = $row->description;
        }
        $og_image = url('/competition_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.partners-page name');
        $subtitle = __('front.partners-subtitle');
        $banner = getImage(getSettingValue('partners'));
        $partners = Partner::orderBy('sort_by', 'asc')->get();
        \View::share('is_page', 'compitation');
        return view('front.pages.compitation', compact('title', 'partners', 'banner', 'subtitle') );
    }
    public function compitation_apply(Request $request)
    {

        $og_title = "معرض الكتاب الإسلامي | التسجيل في المسابقة";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.partners-page name');
        $subtitle = __('front.partners-subtitle');
        $banner = getImage(getSettingValue('partners'));
        $partners = Partner::orderBy('sort_by', 'asc')->get();
        \View::share('is_page', 'compitation_apply');
        return view('front.pages.compitation_apply', compact('title', 'partners', 'banner', 'subtitle') );
    }
    public function user_area(Request $request)
    {

        $title = "معرض الكتاب الإسلامي | منطقه المتسابق";
        \View::share('is_page', 'user_area');
        return view('front.pages.user_area', compact('title') );
    }
    public function user_areaPost(Request $request)
    {
        $validated_data = $request->validate([
            'book1_ans_file'         => 'nullable|mimes:pdf,doc,docx|max:2048', // Max 2MB file size
            'book2_ans_file'         => 'nullable|mimes:pdf,doc,docx|max:2048', // Max 2MB file size
            'book3_ans_file'         => 'nullable|mimes:pdf,doc,docx|max:2048', // Max 2MB file size
        ], [
            'book1_ans_file.mimes' => 'يجب أن يكون الملف بصيغة PDF أو DOC أو DOCX.',
            'book1_ans_file.max' => 'يجب ألا يتجاوز حجم الملف 2 ميغابايت.',
            'book2_ans_file.mimes' => 'يجب أن يكون الملف بصيغة PDF أو DOC أو DOCX.',
            'book2_ans_file.max' => 'يجب ألا يتجاوز حجم الملف 2 ميغابايت.',
            'book3_ans_file.mimes' => 'يجب أن يكون الملف بصيغة PDF أو DOC أو DOCX.',
            'book3_ans_file.max' => 'يجب ألا يتجاوز حجم الملف 2 ميغابايت.',
        ]);
        $user = auth()->user();
        if ($request->hasFile('book1_ans_file')) {
            $f = $request->file('book1_ans_file')->store('users', 'public');
            $user->book1_ans_file = $f;
            $user->save();
            return redirect()->route('page.user_area')->with('success', 'تم ارفاق الملف بنجاح');
        }

        if ($request->hasFile('book2_ans_file')) {
            $f = $request->file('book2_ans_file')->store('users', 'public');
            $user->book2_ans_file = $f;
            $user->save();
            return redirect()->route('page.user_area')->with('success', 'تم ارفاق الملف بنجاح');
        }

        if ($request->hasFile('book3_ans_file')) {
            $f = $request->file('book3_ans_file')->store('users', 'public');
            $user->book3_ans_file = $f;
            $user->save();
            return redirect()->route('page.user_area')->with('success', 'تم ارفاق الملف بنجاح');
        }

        return redirect()->route('page.user_area')->with('error', 'حدث خطأ ما');
    }
    public function compitation_applyPost(Request $request)
    {
        $validated_data = $request->validate([
            'name'          => 'required',
            'email'         => 'required|unique:users',
            'password'      => 'required|min:8',
            'phone'         => 'required|unique:users',
            'identity'      => 'required|image',
            'image'         => 'required|image',
            'age'           => 'required',
            'edu_level'     => 'required',
            'job'           => 'required',
            'nationality'   => 'required',
        ], [
            'name.required'        => 'الاسم مطلوب.',
            'email.required'       => 'البريد الإلكتروني مطلوب.',
            'email.unique'         => 'البريد الإلكتروني مستخدم بالفعل.',
            'password.required'    => 'كلمة المرور مطلوبة.',
            'password.min'         => 'يجب أن تتكون كلمة المرور من 8 أحرف على الأقل.',
            'phone.required'       => 'رقم الهاتف مطلوب.',
            'phone.unique'         => 'رقم الهاتف مستخدم بالفعل.',
            'identity.required'    => ' الهوية مطلوب.',
            'identity.image'    => 'يجب أن يكون الهوية صورة صحيحة.',
            'image.required'       => 'الصورة مطلوبة.',
            'image.image'          => 'يجب أن يكون الملف صورة صحيحة.',
            'age.required'         => 'العمر مطلوب.',
            'edu_level.required'   => 'المستوى التعليمي مطلوب.',
            'job.required'         => 'المهنة مطلوبة.',
            'nationality.required' => 'الجنسية مطلوبة.',
        ]);
        $validated_data['password'] = bcrypt($request->password);
        $password = $validated_data['password_txt'] = $request->password;

        if ($request->hasFile('image')) {
            $validated_data['image'] = $request->file('image')->store('users', 'public');
        }
        if ($request->hasFile('identity')) {
            $validated_data['identity'] = $request->file('identity')->store('users', 'public');
        }

        $user = User::create($validated_data);
        Auth::login($user);
        // Send the password via email
        Mail::to($user->email)->send(new WelcomeMail($password));
        return redirect()->route('page.user_area')->with('success', 'تم التسجيل بنجاح');
    }
    public function sponsors(Request $request)
    {

        $og_title = "معرض الكتاب الإسلامي | الرعاة ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.partners-page name');
        $subtitle = __('front.partners-subtitle');
        $banner = getImage(getSettingValue('partners'));
        $partners = Partner::orderBy('sort_by', 'asc')->get();
        \View::share('is_page', 'sponsors');
        return view('front.pages.partners', compact('title', 'partners', 'banner', 'subtitle') );
    }
    public function authers(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | المؤلفين ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.authers-page name');
        $subtitle = __('front.authers-subtitle');
        $banner = getImage(getSettingValue('authers'));
        $authers = Writer::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $authers->where('name', 'LIKE', "%$request->s%");
        }
        $authers = $authers->paginate(15);
        // $subtitle = __('front.footer-subtitle authers');
        \View::share('is_page', 'authers');
        return view('front.pages.authers', compact('title', 'authers', 'banner') );
    }
    public function authersAjx(Request $request)
    {
        $authers = Writer::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $authers->where('title', 'LIKE', "%$request->s%");
        }
        $authers = $authers->paginate(15);
        $p = $authers->currentPage() + 1;
        $nxt = true;
        if ($p > $authers->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.authers_table', compact('authers') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }
    public function autherShow(Request $request, $id)
    {

        $row = Writer::where('active', '1')->findOrFail($id);
        
        $og_title = "معرض الكتاب الإسلامي |  " .$row->name;
        $og_sub_title = $row->excerpt;
        $og_image = getImage($row->image);
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $subtitle = __('front.teams-page name');
        $title = $row->name;
        $banner = getImage(getSettingValue('teams'));
        \View::share('is_page', 'teams');
        $books = $row->books()->get();
        return view('front.pages.auther-details', compact('title', 'row', 'banner', 'books') );
    }
    public function events(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | الفعاليات ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.events-page name');
        $subtitle = __('front.events-subtitle');
        $banner = getImage(getSettingValue('events'));
        $events = Event::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('date') && !empty($request->date) && $request->date != 'undefined') {
            $events->whereDate('day_date', Carbon::parse($request->date));
        }
        $events = $events->paginate(15);
        
        // $subtitle = __('front.footer-subtitle events');
        \View::share('is_page', 'events');
        return view('front.pages.events', compact('title', 'events', 'banner') );
    }
    
    public function eventsAjx(Request $request)
    {
        $events = Event::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $events->where('title', 'LIKE', "%$request->s%");
        }
        if ($request->has('date') && !empty($request->date) && $request->date != 'undefined') {
            $events->whereDate('day_date', Carbon::parse($request->date));
        }
        $events = $events->paginate(15);
        $p = $events->currentPage() + 1;
        $nxt = true;
        if ($p > $events->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.events_table', compact('events') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }
    public function eventShow(Request $request, $id)
    {

        $row = Event::where('active', '1')->findOrFail($id);
        
        $og_title = "معرض الكتاب الإسلامي |  " .$row->title;
        $og_sub_title = $row->excerpt;
        $og_image = getImage($row->image);
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $subtitle = __('front.teams-page name');
        $title = $row->title;
        $banner = getImage(getSettingValue('teams'));
        \View::share('is_page', 'teams');
        $events = Event::where('active', '1')->where('id', '<>', $row->id)->limit(4)->get();
        return view('front.pages.event-details', compact('title', 'row', 'banner', 'events') );
    }
    public function news(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | الاخبار ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.news-page name');
        $subtitle = __('front.news-subtitle');
        $banner = getImage(getSettingValue('news'));
        $news = Event::where('active', '1')->orderBy('sort_by', 'asc')->get();
        
        // $subtitle = __('front.footer-subtitle news');
        \View::share('is_page', 'news');
        return view('front.pages.news', compact('title', 'news', 'banner') );
    }
    
    public function newsAjx(Request $request)
    {
        $news = News::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('s') && !empty($request->s) && $request->s != 'undefined') {
            $news->where('title', 'LIKE', "%$request->s%");
        }
        $news = $news->paginate(15);
        $p = $news->currentPage() + 1;
        $nxt = true;
        if ($p > $news->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.news_table', compact('news') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }
    public function newsShow(Request $request, $id)
    {

        $row = Event::where('active', '1')->findOrFail($id);
        
        $og_title = "معرض الكتاب الإسلامي |  " .$row->title;
        $og_sub_title = $row->excerpt;
        $og_image = getImage($row->image);
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $subtitle = __('front.teams-page name');
        $title = $row->title;
        $banner = getImage(getSettingValue('teams'));
        \View::share('is_page', 'teams');
        return view('front.pages.news-details', compact('title', 'row', 'banner') );
    }
    public function books(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | الكتب ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.books-page name');
        $subtitle = __('front.books-subtitle');
        $banner = getImage(getSettingValue('books'));
        $books_v = Book::where('active', '1')->orderBy('views', 'asc')->paginate(24);
        $books = Book::where('active', '1')->inRandomOrder()->paginate(24);
        
        // $subtitle = __('front.footer-subtitle books');
        \View::share('is_page', 'books');
        return view('front.pages.books', compact('title', 'books_v', 'books', 'banner') );
    }
    public function booksSearch(Request $request)
    {
        $title = __('front.books-page name');
        $subtitle = __('front.books-subtitle');
        $banner = getImage(getSettingValue('books'));
        $books = Book::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('keywords') && !empty($request->keywords)) {
            $books->where('title', 'LIKE', "%$request->keywords%");
        }
        if ($request->has('filter') && !empty($request->filter)) {
            switch ($request->filter) {
                case 'most_view':
                    $books = $books->orderBy('views', 'desc');
                    break;
                case 'random':
                    $books = $books->inRandom();
                    break;
                
                default:
                $books = $books->orderBy('id', 'desc');
                    break;
            }
        }
        $books = $books->paginate(15);
        
        // $subtitle = __('front.footer-subtitle books');
        \View::share('is_page', 'books');
        return view('front.pages.books_search', compact('title', 'books', 'banner') );
    }
    
    public function booksSearchAjx(Request $request)
    {
        $books = Book::where('active', '1')->orderBy('sort_by', 'asc');
        if ($request->has('keywords') && !empty($request->keywords)) {
            $books->where('title', 'LIKE', "%$request->keywords%");
        }
        if ($request->has('filter') && !empty($request->filter)) {
            switch ($request->filter) {
                case 'most_view':
                    $books = $books->orderBy('views', 'desc');
                    break;
                case 'random':
                    $books = $books->inRandom();
                    break;
                
                default:
                $books = $books->orderBy('id', 'desc');
                    break;
            }
        }
        $books = $books->paginate(15);
        $p = $books->currentPage() + 1;
        $nxt = true;
        if ($p > $books->lastPage()) {
            $nxt = false;
        }
        $view = view('front.pages.books_search_table', compact('books') )->render();
        return response()->json([
            'view' => $view,
            'next' => $nxt,
            'page' => $p,
        ], 200);
    }
    public function bookShow(Request $request, $id)
    {

        $row = Book::where('active', '1')->findOrFail($id);
        $row->views = $row->views + 1;
        $row->save();
        $og_title = "معرض الكتاب الإسلامي |  " .$row->title;
        $og_sub_title = $row->excerpt;
        $og_image = getImage($row->image);
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $subtitle = __('front.teams-page name');
        $title = $row->title;
        $banner = getImage(getSettingValue('teams'));
        \View::share('is_page', 'teams');
        $books = Book::where('active', '1')->where('id', '<>', $row->id)->limit(4)->get();
        return view('front.pages.book-details', compact('title', 'row', 'banner', 'books') );
    }
    public function publisherShow(Request $request, $id)
    {
        $row = Publisher::where('active', '1')->findOrFail($id);
        $og_title = "معرض الكتاب الإسلامي |  " .$row->name;
        $og_sub_title = $row->excerpt;
        $og_image = getImage($row->image);
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $subtitle = __('front.teams-page name');
        $title = $row->title;
        $banner = getImage(getSettingValue('teams'));
        \View::share('is_page', 'teams');
        $books = $row->books()->get();
        return view('front.pages.publisher-details', compact('title', 'row', 'banner', 'books') );
    }
    public function terms(Request $request)
    {

        $title = __('front.terms page name');
        $content = getSettingValue('terms_'.app()->getLocale());
        
        $subtitle = __('front.subtitle terms');
        $banner = "/assets/pic/blogbanner.png";
        \View::share('is_page', 'terms');
        return view('front.pages.page', compact('title', 'content', 'subtitle', 'banner') );
    }
    
    public function privacy(Request $request)
    {

        $title = __('front.privacy page name');
        $content = getSettingValue('privacy_'.app()->getLocale());
        
        $subtitle = __('front.subtitle privacy');
        $banner = getImage(getSettingValue('privacy'));
        \View::share('is_page', 'privacy');
        return view('front.pages.page', compact('title', 'content', 'subtitle', 'banner') );
    }
    public function contact(Request $request)
    {

        $title = __('front.contact-page name');
        $banner = getImage(getSettingValue('contact'));
        
        $subtitle = __('front.contact-subtitle');
        \View::share('is_page', 'contact');
        return view('front.pages.contact', compact('title','banner', 'subtitle') );
    }
    public function contactPost(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            // 'subject' => 'required',
            'message' => 'required',
        ]);
        $data = $request->only(['name', 'email', 'phone', 'subject', 'message']);
        $data['type'] = 'contact';
        $check = false;
        if (preg_match("/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/", $request->get('phone'))) {
            $check = true;
        }
        if (preg_match("/^(00201|201|\+201|01|1)(0|2|1|5)([0-9]{8})$/", $request->get('phone'))) {
            $check = true;
        }
        if (!$check) {
            $data['notes'] = 'spam';
        }
        Contact::create($data);
        return back()->with('success', __('front.contact-message send successfully'));
    }
    public function gallery(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | الصور ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.gallery-page name');
        $subtitle = __('front.gallery-subtitle');
        $banner = getImage(getSettingValue('gallery'));
        $gallery = Files::where('active', '1')
                            ->where('taggable_type', 'LIKE', '%Admin%')
                            ->where('type', 'image')->get()
                            ->groupBy('group')->map(function ($items) {
                                return $items->take(3); // Limit each group to 3 items
                            });
        
        // $subtitle = __('front.footer-subtitle gallery');
        \View::share('is_page', 'gallery');
        return view('front.pages.gallery', compact('title', 'gallery', 'banner') );
    }
    public function galleryDetails(Request $request, $group)
    {
        
        $og_title = "معرض الكتاب الإسلامي |  " . $group;
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = $group;
        $subtitle = __('front.gallery-subtitle');
        $banner = getImage(getSettingValue('gallery'));
        $imgs = Files::where('active', '1')
                            ->where('taggable_type', 'LIKE', '%Admin%')
                            ->whereIn('type', ['image', 'infographic'])
                            ->where('group', ($group == "صور عامة") ? null : $group)
                            ->get();
        
        // $subtitle = __('front.footer-subtitle gallery');
        \View::share('is_page', 'gallery');
        return view('front.pages.gallery-details', compact('title', 'imgs', 'banner') );
    }
    public function media(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | المرئيات ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.media-page name');
        $subtitle = __('front.media-subtitle');
        $banner = getImage(getSettingValue('media'));
        $videos = Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')->where('type', 'video')->where('group', 'فيديوهات')->get();
        $reels = Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')->where('type', 'video')->where('group', 'ريلز')->get();
        
        // $subtitle = __('front.footer-subtitle media');
        \View::share('is_page', 'media');
        return view('front.pages.media', compact('title', 'videos', 'reels', 'banner') );
    }
    public function history(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | تراث المعرض ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.history-page name');
        $subtitle = __('front.history-subtitle');
        $banner = getImage(getSettingValue('history'));
        $videos = Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')->where('type', 'video')->where('group', 'التراث')->get();
        $images = Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')->where('type', 'image')->where('group', 'التراث')->get();
        
        // $subtitle = __('front.footer-subtitle history');
        \View::share('is_page', 'history');
        return view('front.pages.history', compact('title', 'videos', 'images', 'banner') );
    }

    public function register(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | التسجيل ";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.register-page name');
        $banner = getImage(getSettingValue('register'));
        $subtitle = __('front.register-subtitle');
        \View::share('is_page', 'register');
        return view('front.pages.register', compact('title','banner', 'subtitle') );
    }

    public function registerAuther(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | تسجيل المؤلف";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.register-page name');
        $banner = getImage(getSettingValue('register'));
        $subtitle = __('front.register-subtitle');
        \View::share('is_page', 'register');
        return view('front.pages.register-auther', compact('title','banner', 'subtitle') );
    }
    public function postInfoShow(Request $request, $id)
    {
        $row = Files::where('taggable_type', 'LIKE', '%Admin%')->findOrFail($id);
        $og_title = "معرض الكتاب الإسلامي | " . $row->title;
        $og_sub_title = $row->group;
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.register-page name');
        $banner = getImage(getSettingValue('register'));
        $subtitle = __('front.register-subtitle');
        \View::share('is_page', 'register');
        if ($row->group == 'انفوجراف') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'image')
                                                    ->where('group', 'انفوجراف')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.infographic-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'روائع المقولات') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'image')
                                                    ->where('group', 'روائع المقولات')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.quote-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'ريلز') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'ريلز')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'موشن جرافيك') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'موشن جرافيك')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'وايت بورد') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'وايت بورد')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'فيديوهات') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'فيديوهات')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'كتاب وكاتب') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'كتاب وكاتب')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        } else if ($row->group == 'التراث') {
            $related =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'التراث')
                                                    ->where('id', '!=', $row->id)
                                                    ->limit(4)  
                                                    ->orderby('sort_by', 'asc')
                                                    ->get();
            return view('front.pages.video-reels-details', compact('title','banner', 'subtitle', 'row', 'related') );
            
        // } else if ($row->group == '') {
            
        } else {
            abort(404);
        }
        
    }
    public function postListShow(Request $request, $id)
    {
        $og_title = "معرض الكتاب الإسلامي | " . $id;
        $og_sub_title = $id;
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = $id;
        $banner = getImage(getSettingValue('register'));
        $subtitle = __('front.register-subtitle');
        \View::share('is_page', 'register');
        if ($id == 'انفوجراف') {
            
            $rows = Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'infographic')
                                                    ->where('sort_by', '1')
                                                    // ->where('id', '!=', $row->id)
                                                    // ->limit(4)
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            // $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
            //                                         ->where('type', 'image')
            //                                         ->where('group', 'انفوجراف')
            //                                         ->orderby('sort_by', 'asc')
            //                                         ->paginate(24);
            return view('front.pages.infographic', compact('title','banner', 'subtitle', 'rows') );
            
        } else if ($id == 'روائع المقولات') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'image')
                                                    ->where('group', 'روائع المقولات')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.quotes', compact('title','banner', 'subtitle', 'rows') );
            
        } else if ($id == 'ريلز') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'ريلز')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.reels', compact('title','banner', 'subtitle', 'rows') );
            
        } else if ($id == 'فيديوهات') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'فيديوهات')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.videos', compact('title','banner', 'subtitle', 'rows') );
        } else if ($id == 'كتاب وكاتب') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'كتاب وكاتب')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.videos', compact('title','banner', 'subtitle', 'rows') );
        } else if ($id == 'موشن جرافيك') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'موشن جرافيك')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.videos', compact('title','banner', 'subtitle', 'rows') );
        } else if ($id == 'وايت بورد') {
            $rows =  Files::where('active', '1')->where('taggable_type', 'LIKE', '%Admin%')
                                                    ->where('type', 'video')
                                                    ->where('group', 'وايت بورد')
                                                    ->orderby('sort_by', 'asc')
                                                    ->paginate(24);
            return view('front.pages.videos', compact('title','banner', 'subtitle', 'rows') );
            
        // } else if ($row->group == '') {
            
        } else {
            abort(404);
        }
        
    }

    public function registerPublisher(Request $request)
    {
        
        $og_title = "معرض الكتاب الإسلامي | تسجيل دار النشر";
        $og_sub_title = "";
        $og_image = url('/assets/images/logo_og.png');
        \View::share('og_title', $og_title);
        \View::share('og_sub_title', $og_sub_title);
        \View::share('og_image', $og_image);
        $title = __('front.register-page name');
        $banner = getImage(getSettingValue('register'));
        $subtitle = __('front.register-subtitle');
        \View::share('is_page', 'register');
        return view('front.pages.register-publisher', compact('title','banner', 'subtitle') );
    }
    public function registerWriterPost(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'country' => 'required',
            'about' => 'required',
            'books' => 'required',
            'password' => 'required|min:8',
            'image' => 'nullable|image',
            'email' => 'required|email|unique:writers,email',
            // 'phone' => 'required|unique:writers,phone',
        ], [
            'name.required' => 'الاسم مطلوب.',
            'country.required' => 'البلد مطلوب.',
            'about.required' => 'المعلومات مطلوبة.',
            'books.required' => 'الكتب مطلوبة.',
            'password.required' => 'كلمة المرور مطلوبة.',
            'password.min' => 'يجب أن تكون كلمة المرور 8 أحرف على الأقل.',
            'image.image' => 'يجب أن تكون الصورة من نوع صورة صالحة.',
            'email.required' => 'البريد الإلكتروني مطلوب.',
            'email.email' => 'يجب إدخال بريد إلكتروني صالح.',
            'email.unique' => 'هذا البريد الإلكتروني مسجل بالفعل.',
            'phone.required' => 'رقم الهاتف مطلوب.',
            'phone.unique' => 'رقم الهاتف مسجل بالفعل.',
        ]);
        $data = $request->only(['name', 'email', 'phone']);
        $data['username'] = \Str::slug($request->name) . time();
        $data['active'] = 0;
        // Writer::create($data);
        $new = new Writer();
        $new->name = $request->get('name');
        if ($request->hasFile('image')) {
            $new->image = $request->file('image')->store('writers', 'public');
        }
        $new->email = $request->get('email');
        // $new->phone = $request->get('phone');
        $new->user_name = $data['username'];
        // $new->title = $request->get('title');
        // $new->image = $request->get('image');
        $new->about = $request->get('about');
        $new->password = bcrypt($request->get('password'));
        $new->password_txt = '';
        $new->active = '1';
        $new->fb = $request->get('fb');
        $new->tw = $request->get('tw');
        $new->yube = $request->get('yube');
        $new->fields = $request->get('fields');
        $new->country = $request->get('country');
        $new->books = $request->get('books');
        $new->save();
        $password = $request->get('password');
        try{
            Mail::to($new->email)->send(new WelcomeMail($password));
            
        }catch(\Exception $e){
            
        }
        return back()->with('success', 'تم تسجيل حسابك بنجاح يمكنك تسجيل الدخول الي لوحة تحكم حسابك بالضغط هنا');
    }
    public function registerPublisherPost(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'country' => 'required',
            'about' => 'required',
            // 'password' => 'required|min:8',
            'type' => 'required|in:books,technologies',
            'creation_day_date' => 'required',
            'presenter' => 'required',
            'image' => 'nullable|image',
            'email' => 'required|email|unique:publishers,email',
            'phone' => 'required|unique:publishers,phone',
        ], [
            'name.required' => 'الاسم مطلوب.',
            'country.required' => 'البلد مطلوب.',
            'about.required' => 'المعلومات مطلوبة.',
            'password.required' => 'كلمة المرور مطلوبة.',
            'password.min' => 'يجب أن تكون كلمة المرور 8 أحرف على الأقل.',
            'type.required' => 'النوع مطلوب.',
            'type.in' => 'النوع يجب أن يكون إما "books" أو "technologies".',
            'creation_day_date.required' => 'تاريخ يوم الإنشاء مطلوب.',
            'presenter.required' => 'اسم المقدم مطلوب.',
            'image.image' => 'يجب أن تكون الصورة من نوع صورة صالحة.',
            'email.required' => 'البريد الإلكتروني مطلوب.',
            'email.email' => 'يجب إدخال بريد إلكتروني صالح.',
            'email.unique' => 'هذا البريد الإلكتروني مسجل بالفعل.',
            'phone.required' => 'رقم الهاتف مطلوب.',
            'phone.unique' => 'رقم الهاتف مسجل بالفعل.',
        ]);
        $data = $request->only(['name', 'email', 'phone']);
        $data['username'] = \Str::slug($request->name) . time();
        $data['active'] = 0;
        if ($request->hasFile('image')) {
            $data['image'] = $request->file('image')->store('publishers', 'public');
        }
        // Publisher::create($data);
        $new = new Publisher();
        $new->name = $request->get('name');
        $new->email = $request->get('email');
        $new->phone = $request->get('phone');
        $new->user_name = $data['username'];
        $new->about = $request->get('about');
        $new->excerpt = $request->get('excerpt');
        $new->place_1 = $request->get('place_1');
        $new->fb = $request->get('fb');
        $new->tw = $request->get('tw');
        $new->ins = $request->get('ins');
        $new->yube = $request->get('yube');
        $new->url = $request->get('url');
        $p = time();
        $new->password = bcrypt($p);
        $new->password_txt = $p;
        $new->active = '1';
        $new->creation_day_date = $request->get('creation_day_date');
        $new->country = $request->get('country');
        $new->presenter = $request->get('presenter');
        $new->case = $request->get('case');
        $new->type = $request->get('type');
        $new->prev_participation = $request->get('prev_participation');
        $new->need_to_part_this_year = $request->get('need_to_part_this_year');
        $new->save();
        $password = $p;
        try{
            Mail::to($new->email)->send(new WelcomeMail($password));
            
        }catch(\Exception $e){
            
        }
        return back()->with('success', 'تم التسجيل بنجاح يرجي انتظار موافقة الادارة');
    }

}
